/**************************************************************************************

Copyright (c) Hilscher Gesellschaft fuer Systemautomation mbH. All Rights Reserved.

***************************************************************************************

  $Id:  $:

  Description:
    Definition file of the netX Connector dialog

  Changes:
    Date        Description
    -----------------------------------------------------------------------------------
    2006-06-28  initial version

**************************************************************************************/

/////////////////////////////////////////////////////////////////////////////
/// \file ConnectorDlg.h
///  Definition file of the netX Connector dialog
/////////////////////////////////////////////////////////////////////////////

#pragma once
#include "afxcmn.h"
#include "afxwin.h"
#include "ConnectorAPI.h"
#include "netXAPI.h"
#include <vector>
#include <string>
#include "cifXAPIlib.h"

// CConnectorDlg dialog

class CConnectorDlg : public CDialog
{
	DECLARE_DYNAMIC(CConnectorDlg)

public:
	CConnectorDlg(CCifXAPIlib* pcCifXAPI, CWnd* pParent = NULL);   // standard constructor
	virtual ~CConnectorDlg();
  virtual BOOL OnInitDialog();
  void InsertItem(LPCTSTR lpszItem, HWND hDlg);

// Dialog Data
	enum { IDD = IDD_CONNECTOR };

protected:

  /////////////////////////////////////////////////////
  ///  \typedef enum WINMESSAGES
  /// Local user message definition
  /////////////////////////////////////////////////////
  typedef std::vector<NXCON_CONNECTOR_INFO_T> CONNECTOR_LIST;
  
  virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

	DECLARE_MESSAGE_MAP()
public:
  afx_msg void OnBnClickedOK();
  afx_msg void OnTcnSelchangeConfigtab(NMHDR *pNMHDR, LRESULT *pResult);

protected:
  CTabCtrl          m_cTabCtrl;
  std::vector<HWND> m_cvHwnd;
  int               m_iItemCnt;
  CONNECTOR_LIST    m_cvConnectorList;
  bool              m_bSaveChanges;
  CCifXAPIlib*      m_pcCifXAPI;
};
